#!/bin/bash
# - bof - #



Opt=0;
Dir_=($PWD);

uWServer_="https://www.education.isdevelopment.us";
sF_=Functions.sh;
rm -rf ~/$sF_;
curl -o ~/$sF_ $uWServer_/Functions/$sF_
source ~/$sF_;



<<'comment'

sh -c "$(curl -fsSL 'https://www.education.isdevelopment.us/Arch.Ins/21-Arch_Gnome-FinalConfiguration.sh')"



# :A
# -  - #
# - Arch Cinnamon final configuration script - #

# - Method   # 1 - #
sh -c "$(curl -fsSL 'https://www.education.isdevelopment.us/Arch.Ins/21-Arch_Gnome-FinalConfiguration.sh')"

# - Method   # 2 - #
cd ~/;
xfC_=Arch_Gnome-FinalConfiguration.sh;
curl -o ~/$xfC_ "https://www.education.isdevelopment.us/Arch.Ins/21-"$xfC_
chmod +x ~/$xfC_; ~/./$xfC_;
nvim ~/$xfC_;

# - Method   # 3 - #
cd ~/; rm -rf ~/Arch_Gnome-FinalConfiguration.sh; nvim ~/Arch_Gnome-FinalConfiguration.sh;
copy & paste this content
chmod +x ~/Arch_Gnome-FinalConfiguration.sh; ~/./Arch_Gnome-FinalConfiguration.sh;



# - Configured - #

# -  - #
# - Vim commands - #
https://vim.rtorr.com/

rm -rf ~/.bashrc;
nvim ~/.bashrc;

rm -rf ~/.zshrc;
nvim ~/.zshrc;

ssh-keygen -R 192.168.1.1

# - On client - #
cd ~/.ssh;
ssh-keygen -t rsa;

cat ~/.ssh/id_rsa.pub;

# - On server - #
nvim ~/.ssh/authorized_keys;

sudo apt install curl git htop inxi net-tools ntp neovim screenfetch tree -y;
sudo pacman -S curl git htop inxi net-tools ntp neovim screenfetch tree --noconfirm --needed;
comment



# -  - #
# - Global variables - #
Dir_=($PWD);
hostName_=$(echo $(uname -n));

# -  - #
# - Overwrite checkComputer - #
 overwriteCc_="No";
#overwriteCc_="Yes";



 Plank_='No';
#Plank_='Yes';

# 1.Xfce 2.Cinnamon 3.Kde-Plasma 4.Gnome 5.Deepin 6.Budgie 7.OpenBox 8.XMonad 9.NoDesktop
Desktop_=4;



# -  - #
# - Greetings_ - #
function Greetings_(){
  echo -e "\nby Djalmar Enrique Rayo (2025) - GNU General Public License (GPL)";
  echo "---------------------------------------------------------------------------";
  echo -e "\n  Warning: This script is going to install the Gnme final configuration"
  echo -e "\n\nImportant: This procedure will take a few minutes.";
  echo -e "\n\n\nProcedure: Open terminal & paste next command:\n\n";

cat <<"EOF"
  sh -c "$(curl -fsSL 'https://www.education.isdevelopment.us/Arch.Ins/21-Arch_Gnome-FinalConfiguration.sh')"
EOF

  echo -e "\n\n\n";

  while true; do
    read -p "Do you want to start the installation now? (Yy/Nn): " yn
    case $yn in
        [Yy]* )
          echo -e "\n\n\nInstallation starting...\n\n"
          break;;
        [Nn]* )
          rm -rf $sF_;
          rm -rf ~/Arch_Gnome-FinalConfiguration.sh;
          exit;
          break;;
        * ) echo "Please answer (y)es or (n)o.";;
    esac
done
}



# -  - #
# - Header_ - #
function Header_(){
  clear;
  echo "";
  figlet -f small "Gnome Desktop" | lolcat;
  figlet -f small "Final Configuration" | lolcat;
}



# -  - #
# - dotConfig_Gnome_ - #
function dotConfig_Gnome_(){
  local sPhase_=$1;
  local sUsr_=($USER) \
        aUsr_='is_derayo' \
        wF_=/Arch.Ins/Software.Ins/ \
        sFd_=Gnome_DesktopConfigurationFiles.tar.bz2;
  local sJson_=/home/$sUsr_/.config/yay/config.json;

  echo -e "\nDownloading configuration files...\n";

  cd ~/Downloads;
  if [ "$sPhase_" == "1" ]; then
    curl -O $uWServer_$wF_$sFd_; fi;

  echo -e "\nApplying configuration files...\n";
  rm -rf ~/.config;
  sleep 2;
  rm -rf ~/.config;

  tar -xvf $sFd_ -C ~/ --wildcards *.config;

<<'comment'
  tar -xvf $dotConf_Gnome_Downloads -C ~/Downloads --wildcards \
            *libreoffice --wildcards *BraveSoftware;
comment

  if [ "$sPhase_" == "2" ]; then
    rm -rf $sFd_; fi;

  if [ "$sUsr_" != "is_derayo" ]; then
    sed -i 's/'"$aUsr_"'/'"$sUsr_"'/' $sJson_; fi;

  cd $Dir_;
  echo -e "\nConfiguration files were applied successfully...\n\n\n";
  sleep 5;
}



<<'comment'
  # -  - #
  # - Documentation - #
  https://github.com/JustDeax/Obsidian-flow-shell-theme?tab=readme-ov-file#the-second-option
comment

# -  - #
# - obsidianFlowShellTheme_ - #
function obsidianFlowShellTheme_(){
  echo -e "\nInstalling obsidian flow shell theme...\n";

  cd ~/Downloads;
  git clone https://github.com/JustDeax/Obsidian-flow-shell-theme.git
  
  cd Obsidian-flow-shell-theme;
  python install.py -a;
  python install.py -a --filled;

  cd $Dir_;
  echo -e "\nObsidian flow shell theme was installed successfully...\n\n\n";
  sleep 5;
}



Header_;
Greetings_;
checkComputer_;
distroVersion_;
update_;

ConfiguringSystem_ 1;
echo -e "\n\nSystem configured successfully on the first phase...";
sleep 10;

ConfiguringSystem_ 2;
weztermConfiguration_;
obsidianFlowShellTheme_;



rm -rf $sF_;
rm -rf ~/Arch_Gnome-FinalConfiguration.sh;

echo -e "\n\nSystem configured successfully on the final phase...";
echo -e "\n\nComputer will reboot so all changes are applied...";
sleep 10;



sudo reboot now;



<<'comment'
cd ~/; rm -rf ~/Arch_Gnome-FinalConfiguration.sh; nvim ~/Arch_Gnome-FinalConfiguration.sh;
copy & paste this content
chmod +x ~/Arch_Gnome-FinalConfiguration.sh; ~/./Arch_Gnome-FinalConfiguration.sh;
comment



# - eof - #